<?php

namespace Drupal\affiliate;

use Drupal;
use Drupal\Core\Database\Connection;
use Drupal\Core\Entity\EntityInterface;
use Drupal\node\Entity\Node;

/**
 * Service description.
 */
class AccessToggle {

  /**
   * Constructs an AccessToggle object.
   *
   * @param \Drupal\Core\Database\Connection $connection
   *   The database connection.
   */
  public function __construct(protected readonly Connection $connection) {}


  public function setRestricted(EntityInterface $node, int $restrict = 1): bool
  {
     return (bool)$this->connection->upsert('affiliate_access')
       ->fields(['nid', 'locked'])
       ->values([
         'nid' => $node->id(),
         'locked' => $restrict,
       ])->key('nid')
       ->execute();

  }
  public function deleteRecord(EntityInterface $node): bool
  {

    return (bool)$this->connection
      ->delete('affiliate_access')
      ->condition('nid', $node->id())
      ->execute();
  }

  public function isRestricted(EntityInterface $node): int
  {
    $affiliate_access = Drupal::database()
      ->select('affiliate_access', 'sx')
      ->fields('sx', ['locked'])
      ->condition('sx.nid', $node->id())
      ->execute()->fetchAssoc();

      return $affiliate_access['locked'] ?? 1;
  }
}
