<?php

namespace Drupal\affiliate\Controller;

use Drupal;
use Drupal\Core\Controller\ControllerBase;

/**
 * Returns responses for SystemX routes.
 */
class AffiliateController extends ControllerBase {

  public function getLoginTitle(): string
  {
    return 'Login to ' . \Drupal::config('system.site')->get('name');
  }

  /**
   * Builds the response.
   */
  public function login(): array {

    $build['content'] = [
      '#type' => 'markup',
      '#markup' => Drupal::theme()->render('affiliate_login', []),
    ];

    return $build;
  }

}
