<?php

namespace Drupal\affiliate\Plugin\Block;

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Routing\UrlGeneratorInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Theme\ThemeManagerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides login block for affiliates.
 *
 * @Block(
 *   id = "affiliate_login_block",
 *   admin_label = @Translation("Affiliate Login Block"),
 *   category = @Translation("User")
 * )
 */
class AffiliateLoginBlock extends BlockBase implements ContainerFactoryPluginInterface
{

  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    private readonly AccountInterface $account,
    private readonly UrlGeneratorInterface $urlGenerator,
    private readonly ThemeManagerInterface $themeHandler,
    private readonly ConfigFactoryInterface $configFactory
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  public function label()
  {
    return $this->t('Affiliate login block');
  }


  public function build(): array
  {

    return [
      '#type' => 'markup',
      '#markup' => $this->themeHandler->render('affiliate_login_block', [
        'loginLink' => $this->urlGenerator->generateFromRoute('affiliate.login_page'),
        'registerLink' => $this->urlGenerator->generateFromRoute('user.register'),
        'logoutLink' => $this->urlGenerator->generateFromRoute('user.logout'),
        'userIsAnonymous' => $this->account->isAnonymous(),
        'accountName' => $this->account->getAccountName(),
        'siteName' => $this->configFactory->get('system.site')->get('name'),
      ]),
    ];
  }

  public static function create(
    ContainerInterface $container,
    array $configuration,
    $plugin_id,
    $plugin_definition
  ): static {
    return new self(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('current_user'),
      $container->get('url_generator'),
      $container->get('theme.manager'),
      $container->get('config.factory')
    );
  }

}
