<?php

namespace Drupal\affiliate\Plugin\migrate\source;

use Drupal\Core\Database\Query\SelectInterface;
use Drupal\migrate\Plugin\migrate\source\SqlBase;
use Drupal\migrate\Row;

/**
 * The 'affiliate_sx_bridge' source plugin.
 *
 * @MigrateSource(
 *   id = "affiliate_sx_bridge",
 *   source_module = "sx_bridge"
 * )
 */
class AffiliateSxBridgeMigration extends SqlBase {

  /**
   * {@inheritdoc}
   */
  public function query(): SelectInterface
  {
    return $this->select('sx_bridge', 'sx')
      ->fields('sx', ['nid', 'locked',]);

  }

  /**
   * {@inheritdoc}
   */
  public function fields(): array
  {
    return [
      'nid' => $this->t('The node ID.'),
      'locked' => $this->t('The affiliate status of the node.'),
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getIds(): array
  {
    $ids['nid'] = [
      'type' => 'integer',
      'unsigned' => TRUE,
      'size' => 'big',
    ];
    return $ids;
  }

  /**
   * {@inheritdoc}
   */
  public function prepareRow(Row $row): bool
  {
    return parent::prepareRow($row);
  }

}
