<?php declare(strict_types=1);

/*
 * Copyright (c) 2020  https://ee.stanford.edu action@ee.stanford.edu
 *
 * This Academic Free License (the "License") applies to any original work
 * of authorship (the "Original Work") whose owner (the "Licensor") has
 * placed the following licensing notice adjacent to the copyright notice
 * for the Original Work:
 *
 * Licensed under the Academic Free License version 3.0
 *
 */

namespace Suee\CAP\Tests\Authorization;

use PHPUnit\Framework\TestCase;
use Suee\CAP\Authorization\TokenFactory;
use Suee\CAP\Request\ImageRequest;
use Webmozart\Json\JsonDecoder;

class AuthorizationTest extends TestCase
{
    public function setUp(): void
    {
    }

    public function testAuthorization(): void
    {
        $factory = new TokenFactory(getenv('USERNAME'), getenv('CAP_PASSWORD'));
        $token = $factory->request();
        $tokenData = $token->getTokenData();
        self::assertArrayHasKey('access_token', $tokenData);
        $imageRequest = new ImageRequest($token);
        $imageRequest->setQueryParam('uids', 'reric');
        $response = $imageRequest->getRequest();
        $json = $response->getBody()->getContents();
        $decoder = new JsonDecoder();
        $decoder->setObjectDecoding(JsonDecoder::ASSOC_ARRAY);
        $arrayCopy = $decoder->decode($json);
        self::assertArrayHasKey('uid', $arrayCopy['values'][0]);
        self::assertJson($json);
        self::assertEquals('reric', $arrayCopy['values'][0]['uid']);
    }
}
