<?php declare(strict_types=1);

/*
 * Copyright (c) 2020  https://ee.stanford.edu action@ee.stanford.edu
 *
 * This Academic Free License (the "License") applies to any original work
 * of authorship (the "Original Work") whose owner (the "Licensor") has
 * placed the following licensing notice adjacent to the copyright notice
 * for the Original Work:
 *
 * Licensed under the Academic Free License version 3.0
 *
 */

namespace Suee\CAP\Authorization;

class TokenError
{
    private array $errors;
    private string $error;
    private string $errorType;
    private string $errorDescription;

    private int $errorCode = 0;

    public function __construct(array $errors, $code = 0)
    {
        $this->errors = $errors;
        $this->checkForErrorKeys();
        $errorDescriptionParts = explode(':', $this->errors['error_description']);
        $this->error = $this->errors['error'];
        $this->errorType = trim($errorDescriptionParts[0]);
        $this->errorDescription = trim($errorDescriptionParts[1]);
    }

    /**
     * @return string
     */
    public function getError(): string
    {
        return $this->error;
    }

    /**
     * @return string
     */
    public function getErrorType(): string
    {
        return $this->errorType;
    }

    /**
     * @return string
     */
    public function getErrorDescription(): string
    {
        return $this->errorDescription;
    }

    private function checkForErrorKeys(): void
    {
        if (!isset($this->errors['error'])) {
            throw new \InvalidArgumentException('Key \'error\' not found.');
        }
        if (!isset($this->errors['error_description'])) {
            throw new \InvalidArgumentException('Key \'error_description\' not found.');
        }
    }
}
