<?php declare(strict_types=1);

/*
 * Copyright (c) 2020  https://ee.stanford.edu reric@ee.stanford.edu
 *
 * This Source Code Form is subject to the
 * terms of the Mozilla Public License, v. 2.0.
 *
 * If a copy of the MPL was not distributed with this file,
 * You can obtain one at https://mozilla.org/MPL/2.0/.
 *
 *
 */

namespace Suee\Mupdf\Mutool;

final class MergeOptions
{
    public const DECOMPRESS = 'decompress'; // : decompress all streams (except compress-fonts/images)
    public const COMPRESS = 'compress'; // : compress all streams
    public const COMPRESS_FONTS = 'compress-fonts'; // : compress embedded fonts
    public const COMPRESS_IMAGES = 'compress-images'; // : compress images
    public const ASCII = 'ascii'; // : ASCII hex encode binary streams
    public const PRETTY = 'pretty'; // : pretty-print objects with indentation
    public const LINEARIZE = 'linearize'; // : optimize for web browsers
    public const CLEAN = 'clean'; // : pretty-print graphics commands in content streams
    public const SANITIZE = 'sanitize'; // : sanitize graphics commands in content streams
    public const GARBAGE = 'garbage'; // : garbage collect unused objects
    public const INCREMENTAL = 'incremental'; // : write changes as incremental update
    public const CONTINUE_ON_ERROR = 'continue-on-error'; // : continue saving the document even if there is an error
    public const DECRYPT = 'decrypt'; // : write unencrypted document
    public const ENCRYPT = 'encrypt';
    public const PERMISSIONS = 'permissions'; // : document permissions to grant when encrypting
    public const USER_PASSWORD = 'user-password'; // : password required to read document
    public const OWNER_PASSWORD = 'owner-password'; // : password required to edit document
    public const REGENERATE_ID = 'regenerate-id'; // : (default yes) regenerate document id

    public const ENCRYPT_RC_4_40 = 'rc4-40'; // : write encrypted document
    public const ENCRYPT_RC_4_128 = 'rc4-128'; // : write encrypted document
    public const ENCRYPT_AES_128 = 'aes-128'; // : write encrypted document
    public const ENCRYPT_AES_256 = 'aes-256'; // : write encrypted document

    public const GARBAGE_COMPACT = 'garbage=compat'; // and compact cross reference table
    public const GARBAGE_DEDUPLICATE = 'garbage=deduplicate'; // ... and remove duplicate objects

    public const VALID_OPTIONS = [
      self::DECOMPRESS,
      self::COMPRESS,
      self::COMPRESS_FONTS,
      self::COMPRESS_IMAGES,
      self::ASCII,
      self::PRETTY,
      self::LINEARIZE,
      self::CLEAN,
      self::SANITIZE,
      self::GARBAGE,
      self::GARBAGE_COMPACT,
      self::GARBAGE_DEDUPLICATE,
      self::INCREMENTAL,
      self::CONTINUE_ON_ERROR,
      self::DECOMPRESS,
      self::ENCRYPT,
      self::PERMISSIONS,
      self::USER_PASSWORD,
      self::OWNER_PASSWORD,
      self::REGENERATE_ID,
    ];

    public const REQUIRES_OPTION = [
      self::ENCRYPT, // Encrypt also requires one of either USER_PASSWORD, or OWNER_PASSWORD
      self::REGENERATE_ID, // default = true
    ];

    public const VALID_GARBAGE_OPTIONS = [
      self::GARBAGE_COMPACT,
      self::GARBAGE_DEDUPLICATE,
    ];

    public const VALID_ENCRYPT_OPTIONS = [
      self::ENCRYPT_RC_4_40,
      self::ENCRYPT_RC_4_128,
      self::ENCRYPT_AES_128,
      self::ENCRYPT_AES_256,
    ];
}
