<?php

namespace Drupal\orglist\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Orglist form.
 */
class OrglistStaffSortForm extends OrglistBaseSortForm {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {

        $form = parent::buildForm($form, $form_state);
      $staffTypes = $form_state->getBuildInfo()['args'][0]['staff_types'];

      $form['type'] = [
       '#type' => 'select2',
       '#title' => $this->t('Type'),
       '#options' => $staffTypes,
       '#required' => false,
       '#default_value' => $this->getRequest()->query->get('type') ?? 'all',
       '#select2' => [
         'dropdownAutoWidth' => true,
         'dropdownClass' => 'all',
       ],
     ];
    return $form;
  }

}
