<?php

namespace Drupal\orglist\Security;

use Drupal;
use Drupal\Core\Access\AccessResult;
use Drupal\Core\Access\AccessResultInterface;
use Drupal\Core\Config\ImmutableConfig;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\orglist\Form\SettingsForm;

class Access
{
    private ImmutableConfig $config;

    use StringTranslationTrait;

    public function __construct()
    {

            $this->config = Drupal::config('orglist.settings');

    }

    public function typeIsEnabled(string $type): bool
    {
        return (bool)($this->config->get(sprintf(SettingsForm::SETTINGS_PERSON_TYPE_FORMAT, $type)) ?? false);
    }

    public function facultyIsEnabled(): bool
    {
        return $this->typeIsEnabled('professor');
    }

    public function staffIsEnabled(): bool
    {
        return $this->typeIsEnabled('admin_research_staff');
    }

    public function lecturerIsEnabled(): bool
    {
        return $this->typeIsEnabled('adjunct_lecturer');
    }

    public function courtesyIsEnabled(): bool
    {
        return $this->typeIsEnabled('courtesy_professor');
    }

    public function postDocIsEnabled(): bool
    {
        return $this->typeIsEnabled('postdoc');
    }

    public function visitorIsEnabled(): bool
    {
        return $this->typeIsEnabled('visitor');
    }

    public function studentIsEnabled(): bool
    {
        return $this->typeIsEnabled('student');
    }

    public function consultingIsEnabled(): bool
    {
        return $this->typeIsEnabled('consulting_professor');

    }

}