<?php

namespace Drupal\orglist\Form;

use Drupal;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

class OrglistBaseSortForm extends FormBase
{

    public function getFormId()
    {
        return sprintf('%s_sort_form', str_replace('.', '_', Drupal::routeMatch()->getRouteName()));

    }

    private function buildLimitOptions(int $count): array
    {
        $increment = $count / 10;

        for($i=1; $i<=$increment; $i++) {
            $c = sprintf('%d0', $i);
            $options[$c] = $c;
        }
        $options[$count] = $count;

        return $options;
    }

    public function buildForm(array $form, FormStateInterface $form_state)
    {
        $formClasses = [
          'd-flex',
          'justify-content-between',
          'row',
            'mb-4',
            'row-cols-1',
        ];

        $form['sort'] = [
          '#title' => $this->t('Sort'),
          '#type' => 'select',
          '#options' => [
            'asc' => $this->t('Asc'),
            'desc' => $this->t('Desc'),
          ],
          '#default_value' => $this->getRequest()->query->getAlpha('sort'),
          '#required' => false,
        ];

       $args = $form_state->getBuildInfo()['args'];

        $count = (int)$args[0]['count'];

        $form['limit'] = [
          '#title' => $this->t('Limit'),
          '#default_value' => $this->getRequest()->query->getInt('limit', 10),
          '#type' => 'select2',
          '#options' => $this->buildLimitOptions($count),
          '#select2' => [
            'dropdownAutoWidth' => true,
            'dropdownClass' => 'all',
          ],
          '#required' => false,
        ];
        $formClasses[] = sprintf('row-cols-md-%d', \count($form));

        $form['#attributes']['class'] += $formClasses;


        $form['#attributes']['onchange'] = 'this.submit();';
        return $form;
    }

    public function validateForm(array &$form, FormStateInterface $form_state)
    {
        $form_state->setSubmitted();

        parent::validateForm($form,
          $form_state); // TODO: Change the autogenerated stub
    }

    public function submitForm(array &$form, FormStateInterface $form_state)
    {
        $getValue = $form_state->getValue(...);

        $query = [];

        if('' !== $getValue('limit')) {
            $query['limit'] = $getValue('limit');
        }
        if('' !== $getValue('sort')) {
            $query['sort'] = $getValue('sort');
        }
        if($form_state->hasValue('type') && '' !== $getValue('type')) {
            $query['type'] = $getValue('type');
        }
        $options = [];
        $options['query'] = $query;
        $options['absolute'] = true;

        $form_state->setRedirect('<current>', [], $options);
    }
}