<?php declare(strict_types=1);

namespace Drupal\orglist\Http;

use Drupal\Core\Config\Config;
use Drupal\Core\Site\Settings;
use GuzzleHttp\Client;
use GuzzleHttp\Utils;
use function GuzzleHttp\default_user_agent;

class OrglistClientFactory
{
    public static function get(?string $orglistDevice = null, ?string $orglistToken = null): Client
    {
        $config = \Drupal::config('orglist.settings');

        return  \Drupal::service('http_client_factory')->fromOptions([
          'base_uri' => sprintf('%s/', rtrim($config->get('api_url'), '/')),
          'http_errors' => false,
          'headers' => [
            'User-Agent' => 'Drupal/' . \Drupal::VERSION . ' (+https://www.drupal.org/) Stanford Electrical Engineering Orglist (+https://ee.stanford.edu) ' . default_user_agent(),
            'X-Orglist-Token'=> $orglistToken ?? $config->get('api_token') ?? '',
            'X-Orglist-Device' => $orglistDevice ?? $config->get('api_device') ?? '',
              'X-Orglist-Limit' => -1,
          ],
        ]);
    }
}