<?php

namespace Drupal\orglist\Plugin\Menu;

use Drupal\Component\Render\MarkupInterface;
use Drupal\Core\Menu\MenuLinkDefault;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\orglist\Security\Access;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * A menu link that displays count of messages.
 */
class OrglistLecturerMenuLink extends MenuLinkDefault
{

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): ContainerFactoryPluginInterface
  {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('menu_link.static.overrides'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getTitle(): string|MarkupInterface
  {
    return $this->t('Lecturers');
  }

  /**
   * {@inheritdoc}
   */
  public function getRouteName(): string
  {
    return 'orglist.lecturer';
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheTags(): array
  {
    // @DCG Invalidate this tags when messages are created or removed.
    return ['orglist.lecturer'];
  }

  public function isEnabled(): bool
  {
      return (new Access())->lecturerIsEnabled();
  }

}
