<?php

namespace Drupal\orglist\Cache\Context;

use Drupal\Core\Cache\CacheableMetadata;
use Drupal\Core\Cache\Context\CacheContextInterface;
use Drupal\Core\Cache\Context\RequestStackCacheContextBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines the ExampleCacheContext service.
 *
 * Cache context ID: 'orglist'.
 */
class OrglistCacheContext extends RequestStackCacheContextBase implements CacheContextInterface {

  /**
   * {@inheritdoc}
   */
  public static function getLabel(): string|TranslatableMarkup
  {
    return t('Orglist');
  }

  /**
   * {@inheritdoc}
   */
  public function getContext(): string
  {
      return $this->requestStack->getCurrentRequest()?->getClientIp() ?? '0';
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheableMetadata(): CacheableMetadata
  {
    return (new CacheableMetadata())->setCacheMaxAge(3600)->addCacheTags(['orglist']);
  }

}
