<?php

namespace Drupal\orglist\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Drupal\menu_link_content\MenuLinkContentInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

class OrglistMenuLinkDerivative extends DeriverBase implements ContainerDeriverInterface
{

  public static function create(
    ContainerInterface $container,
    $base_plugin_id
  ) {
    return new static($base_plugin_id);
  }

  public function getDerivativeDefinition(
    $derivative_id,
    $base_plugin_definition
  ) {
    return parent::getDerivativeDefinition($derivative_id,
      $base_plugin_definition); // TODO: Change the autogenerated stub
  }

  public function getDerivativeDefinitions($base_plugin_definition): array
  {
    $links = [];

  $links['testing_link'] = [
    'title' => 'Test Link',
    'route_name' => 'orglist.test_link',
      'enabled' => 1,
  ] + $base_plugin_definition;

    // We assume we don't have too many...
   /* $products = [];
    foreach ($products as $id => $product) {
      $links[$id] = [
          'title' => $product->label(),
          'route_name' => $product->toUrl()->getRouteName(),
          'route_parameters' => ['product' => $product->id()]
        ] + $base_plugin_definition;
    }*/

    return $links;

  }


}
