<?php

namespace Drupal\orglist\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Url;
use Drupal\orglist\Cache\CacheUtility;
use Symfony\Component\HttpFoundation\RedirectResponse;

class CacheController extends ControllerBase
{
    private function reloadPage()
    {
        $request = \Drupal::requestStack()->getCurrentRequest();

        if ($request?->server->get('HTTP_REFERER')) {
            return $request?->server->get('HTTP_REFERER');
        }

        return base_path();
    }

    public function flushCache(): RedirectResponse
    {
        $routeName = \Drupal::routeMatch()->getRouteName();
        $cacheUtility = new CacheUtility();
        match($routeName) {
            'orglist.cache.flush_all_image' => $cacheUtility->rebuildAllImageCache(),
            'orglist.cache.flush_faculty' => $cacheUtility->refresh(CacheUtility::CACHE_KEY_FACULTY),
            'orglist.cache.flush_staff' => $cacheUtility->refresh(CacheUtility::CACHE_KEY_STAFF),
            'orglist.cache.flush_courtesy' => $cacheUtility->refresh(CacheUtility::CACHE_KEY_COURTESY),
            'orglist.cache.flush_consulting' => $cacheUtility->refresh(CacheUtility::CACHE_KEY_CONSULTING),
            'orglist.cache.flush_lecturer' => $cacheUtility->refresh(CacheUtility::CACHE_KEY_LECTURER),
            'orglist.cache.flush_student' => $cacheUtility->refresh(CacheUtility::CACHE_KEY_STUDENT),
            'orglist.cache.flush_visitor' => $cacheUtility->refresh(CacheUtility::CACHE_KEY_VISITOR),
            'orglist.cache.flush_postdoc' => $cacheUtility->refresh(CacheUtility::CACHE_KEY_POSTDOC),
            'orglist.cache.flush_areas' => $cacheUtility->refresh(CacheUtility::CACHE_KEY_ORG_GROUP),
            'orglist.cache.flush_people_types' => $cacheUtility->refresh(CacheUtility::CACHE_KEY_PERSON_TYPE),
            'orglist.cache.flush_faculty_image' => $cacheUtility->rebuildImageCacheOfType(CacheUtility::CACHE_KEY_IMAGE_FACULTY),
            'orglist.cache.flush_staff_image' => $cacheUtility->rebuildImageCacheOfType(CacheUtility::CACHE_KEY_IMAGE_STAFF),
            'orglist.cache.flush_courtesy_image' => $cacheUtility->rebuildImageCacheOfType(CacheUtility::CACHE_KEY_IMAGE_COURTESY),
            'orglist.cache.flush_lecturer_image' => $cacheUtility->rebuildImageCacheOfType(CacheUtility::CACHE_KEY_IMAGE_LECTURER),
            'orglist.cache.flush_consulting_image' => $cacheUtility->rebuildImageCacheOfType(CacheUtility::CACHE_KEY_IMAGE_CONSULTING),
            default => $cacheUtility->refreshAll(),
        };

        return new RedirectResponse($this->reloadPage());
    }
}