<?php

namespace Drupal\orglist\Form;

use Drupal\Component\Utility\NestedArray;
use Drupal\Core\Cache\Cache;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormState;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Routing\RedirectDestination;
use Drupal\Core\Url;
use Drupal\orglist\Cache\CacheUtility;
use Drupal\orglist\Request\Request;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Response;

/**
 * Provides a Orglist form.
 */
class OrglistFacultySortForm extends FormBase {

    /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'orglist_orglist_faculty_sort';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {

      $args = $form_state->getBuildInfo()['args'][0];

      $formClasses = [
        'd-flex',
        'justify-content-between',
        'row',
        $args['rowClass'],
      ];

    $form['sort'] = [
      '#title' => $this->t('Sort'),
      '#type' => 'select',
        '#options' => [
          'asc' => $this->t('Asc'),
            'desc' => $this->t('Desc'),
        ],
        '#default_value' => $this->getRequest()->query->getAlpha('sort'),
        '#required' => false,
    ];

    $count = $args['count'];

     $increment = $count / 10;
        for($i=1; $i<=$increment; $i++) {
            $c = sprintf('%d0', $i);
            $options[$c] = $c;
        }
        $options[$count] = $count;
      $form['limit'] = [
        '#title' => $this->t('Limit'),
        '#default_value' => $this->getRequest()->query->getInt('limit', 10),
        '#type' => 'select2',
        '#options' => $options,
        '#select2' => [
          'dropdownAutoWidth' => true,
          'dropdownClass' => 'all',
        ],
        '#required' => false,
      ];

      if(isset($args['professorTypes'])) {

          $form['type'] = [
            '#type' => 'select2',
            '#title' => $this->t('Type'),
              '#default' => 'all',
              '#options' => $args['professorTypes'],
              '#required' => false,
              '#default_value' => $this->getRequest()->query->get('type') ?? 'active',
            '#select2' => [
              'dropdownAutoWidth' => true,
              'dropdownClass' => 'all',
            ],
          ];
      }

      $form['areas'] = [
        '#title' => $this->t('Areas'),
          '#description' => $this->t('Filter by areas'),
          '#default_value' => $this->getRequest()->query->get('areas'),
        '#type' => 'select2',
        '#options' => $args['orgGroupOptions'],
        '#required' => false,
         '#select2' => [
          'dropdownAutoWidth' => true,
          'dropdownClass' => 'all',
         ],
      ];



    $form['#attributes']['class'] += $formClasses;


    $form['#attributes']['onchange'] = 'this.submit();';
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state): void
  {
    $form_state->setSubmitted();
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void
  {

      $getValue = $form_state->getValue(...);

      $query = [];
      if('' !== $getValue('areas')) {
          $query['areas'] = $getValue('areas');
      }
      if('' !== $getValue('limit')) {
          $query['limit'] = $getValue('limit');
      }
      if('' !== $getValue('sort')) {
          $query['sort'] = $getValue('sort');
      }
      if('' !== $getValue('type')) {
          $query['type'] = $getValue('type');
      }
        $options = [];
        $options['query'] = $query;
        $options['absolute'] = true;

        $form_state->setRedirect('orglist.faculty', [], $options);

  }



}
