<?php

namespace Drupal\orglist;

use Drupal;
use Drupal\orglist\Cache\CacheUtility;
use Drupal\orglist\Security\Access;
use Drupal\user\Entity\Role;
use Drupal\Core\Language\LanguageInterface;
use function mb_strtolower;
use function preg_replace;

class Utils
{

    public static function isAdmin(): bool
    {
        $roles = Role::loadMultiple(Drupal::currentUser()->getRoles());
        foreach($roles as $role) {
            if($role->isAdmin()) {
               return true;
            }
        }
        return false;
    }

    public static function getMachineName(string $text): string
    {
        $transliterated = Drupal::transliteration()->transliterate($text, LanguageInterface::LANGCODE_DEFAULT, '_');
        $transliterated = mb_strtolower($transliterated);

        return preg_replace('@[^a-z0-9_.]+@', '_', $transliterated);
    }

    public static function sortArrayBy(array $values, string $key, string $direction): array
    {

        uasort($values, static function($value, $value2) use($key, $direction) {
            if(!isset($value[$key], $value2[$key])) {
                return false;
            }
            if(strtolower($direction) === 'asc') {
                return $value[$key] <=> $value2[$key];
            }
            return $value2[$key] <=> $value[$key];
        });

        return $values;
    }
    public static function checkEnabledByCid(string $cid, $default = false): bool
    {
        $accessChecker = new Access();

        return match ($cid) {
            default => $default,
            CacheUtility::CACHE_KEY_FACULTY => $accessChecker->facultyIsEnabled(),
            CacheUtility::CACHE_KEY_STAFF => $accessChecker->staffIsEnabled(),
            CacheUtility::CACHE_KEY_COURTESY => $accessChecker->courtesyIsEnabled(),
            CacheUtility::CACHE_KEY_LECTURER => $accessChecker->lecturerIsEnabled(),
            CacheUtility::CACHE_KEY_VISITOR => $accessChecker->visitorIsEnabled(),
            CacheUtility::CACHE_KEY_STUDENT => $accessChecker->studentIsEnabled(),
            CacheUtility::CACHE_KEY_POSTDOC => $accessChecker->postDocIsEnabled(),
            CacheUtility::CACHE_KEY_CONSULTING => $accessChecker->consultingIsEnabled(),
            CacheUtility::CACHE_KEY_PERSON_TYPE, CacheUtility::CACHE_KEY_ORG_GROUP => true,
            CacheUtility::CACHE_KEY_ADMIN => false,
        };
    }
}