Library to easily create self-signed certificates for signing and encryption in SAML applications.

```php
$distinguishedName = new DistinguishedName([
            // Defaults
            'countryName' => 'US',
            'stateOrProvinceName' => 'California',
            'localityName' => 'Stanford',
            'organizationName' => 'Stanford University',
            // Required
            'organizationalUnitName' => 'Electrical Engineering',
            'commonName' => 'ee.stanford.edu',
            // Optional
            'emailAddress' => 'email@email.com'
]);

$cert = new Certificate($distinguishedName, 4096, OPENSSL_KEYTYPE_RSA, (365 * 10));
$signed = $cert->export();
$signed->writeSigningRequest(__DIR__.'/test.csr');
$signed->writePrivateKey(__DIR__.'/test.key');
$signed->writeCertificate(__DIR__.'/test.crt');
```
