<?php declare(strict_types=1);

/*
 * Copyright (c) 2020  https://ee.stanford.edu action@ee.stanford.edu
 *
 * This Academic Free License (the "License") applies to any original work
 * of authorship (the "Original Work") whose owner (the "Licensor") has
 * placed the following licensing notice adjacent to the copyright notice
 * for the Original Work:
 *
 * Licensed under the Academic Free License version 3.0
 *
 */

namespace Suee\SamlCert\Tests;

use PHPUnit\Framework\TestCase;
use Suee\SamlCert\DistinguishedName;
use Symfony\Component\OptionsResolver\Exception\MissingOptionsException;

class DistinguishedNameTest extends TestCase
{
    public function setUp(): void
    {
        parent::setUp(); // TODO: Change the autogenerated stub
    }

    public function testConstructSuccess(): void
    {
        $dn = new DistinguishedName([
            'commonName' => 'ee.stanford.edu',
            'organizationalUnitName' => 'Electrical Engineering',
        ]);
        $this->assertSame([
            'countryName' => 'US',
            'stateOrProvinceName' => 'California',
            'localityName' => 'Stanford',
            'organizationName' => 'Stanford University',
            'organizationalUnitName' => 'Electrical Engineering',
            'commonName' => 'ee.stanford.edu',
        ], $dn->toArray());
    }
    public function testConstructFailure(): void
    {
        $this->expectException(MissingOptionsException::class);
        new DistinguishedName();
    }
}
