<?php declare(strict_types=1);

/*
 * Copyright (c) 2020  https://ee.stanford.edu action@ee.stanford.edu
 *
 * This Academic Free License (the "License") applies to any original work
 * of authorship (the "Original Work") whose owner (the "Licensor") has
 * placed the following licensing notice adjacent to the copyright notice
 * for the Original Work:
 *
 * Licensed under the Academic Free License version 3.0
 *
 */

namespace Suee\SamlCert;

use function file_put_contents;

class SignedCertificate
{
    public function __construct(
        private readonly string $signingRequest,
        private readonly string $privateKey,
        private readonly string $certificate,
    ) {
    }

    public function getSigningRequest(): string
    {
        return $this->signingRequest;
    }

    public function getPrivateKey(): string
    {
        return $this->privateKey;
    }

    public function getCertificate(): string
    {
        return $this->certificate;
    }

    public function writeSigningRequest(string $fileName): bool
    {
        $this->checkPath($fileName);

        return false !== file_put_contents($fileName, $this->signingRequest);
    }

    public function writePrivateKey(string $fileName): bool
    {
        $this->checkPath($fileName);
        return false !== file_put_contents($fileName, $this->privateKey);
    }

    public function writeCertificate(string $fileName): bool
    {
        $this->checkPath($fileName);
        return false !== file_put_contents($fileName, $this->certificate);
    }
    
    private function checkPath(string $fileName): void
    {
        if(!is_writable(dirname($fileName))) {
            throw new \RuntimeException('Unable to write file.');
        }
    }
}
