<?php declare(strict_types=1);

/*
 * Copyright (c) 2020  https://ee.stanford.edu action@ee.stanford.edu
 *
 * This Academic Free License (the "License") applies to any original work
 * of authorship (the "Original Work") whose owner (the "Licensor") has
 * placed the following licensing notice adjacent to the copyright notice
 * for the Original Work:
 *
 * Licensed under the Academic Free License version 3.0
 *
 */

namespace Suee\SamlCert\Tests;

use const OPENSSL_KEYTYPE_RSA;
use PHPUnit\Framework\TestCase;
use Suee\SamlCert\Certificate;
use Suee\SamlCert\DistinguishedName;

class CertificateTest extends TestCase
{
    public function testCertificate(): void
    {
        $distinguishedName = new DistinguishedName([
            'commonName' => 'ee.stanford.edu',
            'organizationalUnitName' => 'Electrical Engineering',
        ]);

        $cert = new Certificate($distinguishedName, 4096, OPENSSL_KEYTYPE_RSA, (365 * 10));
        $this->assertEquals(3650, $cert->getDays());
        $this->assertEquals(4096, $cert->getBits());
        $this->assertSame(0, $cert->getKeyType());
    }

    public function testKeyTypeFail(): void
    {
        $distinguishedName = new DistinguishedName([
            'commonName' => 'ee.stanford.edu',
            'organizationalUnitName' => 'Electrical Engineering',
        ]);

        $this->expectExceptionMessage('keyType must be one of the OPENSSL_KEYTYPE_* constants.');
        $cert = new Certificate($distinguishedName, 4096, 23, (365 * 10));
    }
}
