<?php declare(strict_types=1);

/*
 * Copyright 2025 Stanford Electrical Engineering
 * https:/ee.stanford.edu <reric@ee.stanford.edu>
 *
 * Licensed under the Academic Free License version 3.0
 *
 */

use PhpCsFixer\Config;

$header = '';

if (file_exists(__DIR__.'/header.txt')) {
    $header = file_get_contents('header.txt');
}
return (new Config())
  ->setRiskyAllowed(true)
  ->setRules(
      [
      '@PSR2' => true,
      '@PHP8x3Migration' => true,
      'header_comment' => ['header' => $header],
      'ordered_class_elements' => true,
      'ordered_imports' => true,
      'no_mixed_echo_print' => ['use' => 'print'],
      'strict_param' => true,
      'strict_comparison' => true,
      'single_import_per_statement' => false,
      'phpdoc_order' => true,
      'array_syntax' => ['syntax' => 'short'],
      'phpdoc_add_missing_param_annotation' => true,
      'psr_autoloading' => true,
      'phpdoc_var_without_name' => false,
        'declare_strict_types' => true,
        'no_unused_imports' => true,
        'no_useless_else' => true,
        'no_useless_return' => true,
       'global_namespace_import' => [
           'import_classes' => true,
           'import_constants' => true,
           'import_functions' => true,
       ],
       'no_extra_blank_lines' => [
            'tokens' => [
                'break',
                'continue',
                'extra',
                'return',
                'throw',
                'parenthesis_brace_block',
                'square_brace_block',
                'curly_brace_block',
            ],
      ],
    ]
  )->setFinder(
      PhpCsFixer\Finder::create()
      ->ignoreDotFiles(true)
      ->ignoreVCS(true)
      ->name('*.php')
      ->in([
        'src',
    'tests',
      ])
  );
