# Stanford API Authentication

This is a library to authenticate to Stanford University's API.

This library is compatible with PSR6, PSR17, and PSR18.

## Example

```php
$tokenFactory = new TokenFactory('username', 'password');

// instance of Suee\StanfordAuthorization\Authorization\Token
$token = $tokenFactory->getToken();
$header = $token->getTokenHeader(); // ['Authorization' => 'Bearer {token}];
```

You can also pass in Http Client implementing Psr\Http\Client\ClientInterface;
```php
// example with symfony/http-client
$client = new \Symfony\Component\HttpClient\Psr18Client();
// or using http-discovery
$client = Suee\StanfordAuthorization\Authorization\Factory\PsrFactory::createClient()

$tokenFactory = new TokenFactory('username', 'password', client: $client);
```
If you want to use caching pass an instance of use Psr\SimpleCache\CacheInterface;
```php
// using symfony/cache
$filesystemAdapter = new FilesystemAdapter('Your-namespace', 3600, sprintf('%s/token-cache/', sys_get_temp_dir()));
$cache = new Symfony\Component\Cache\Psr16Cache($filesystemAdapter);
$tokenFactory = new TokenFactory('username', 'password', cache: $cache);

```

If you do not pass a cache instance, one will try to be discovered finally giving up on caching.
