<?php declare(strict_types=1);

namespace Tests\Suee\StanfordAuthorization\Authorization;

use PHPUnit\Framework\TestCase;
use Suee\StanfordAuthorization\Authorization\TokenError;
use PHPUnit\Framework\Attributes\CoversClass;

#[CoversClass(TokenError::class)]
class TokenErrorTest extends TestCase
{
    public function testErrorDataIsAccessible(): void
    {
        // Ensure ALL keys used by TokenError are present to avoid trim(null)
        $data = [
            'error' => 'invalid_client',
            'error_description' => '', // Added spaces to test trim
        ];
        
        $error = new TokenError($data);
        
        // Assertions
        $this->assertSame('invalid_client', $error->getError());
        
        // If line 31 trims the description, this will pass
        $this->assertSame('', $error->getErrorDescription());
    }

    /**
     * Test specifically for PHP 8.3-8.5 compatibility with null values
     */
    public function testHandlesUnexpectedNullValues(): void
    {
        // If the class is not guarded, this might still fail until you fix the class.
        // But the test should represent a 'safe' empty state.
        $data = [
            'error' => '', 
            'error_description' => ''
        ];
        
        $error = new TokenError($data);
        $this->assertEmpty($error->getError());
    }
}
