<?php declare(strict_types=1);

namespace Tests\Suee\StanfordAuthorization\Authorization;

use PHPUnit\Framework\TestCase;
use Suee\StanfordAuthorization\Authorization\Token;
use PHPUnit\Framework\Attributes\CoversClass;

#[CoversClass(Token::class)]
class TokenTest extends TestCase
{
    private array $validData;

    protected function setUp(): void
    {
        $this->validData = [
            'access_token' => 'test_token_84',
            'token_type'   => 'Bearer',
            'expires_in'   => 3600,
            'scope'        => 'all',
            'jti'          => 'uid_999'
        ];
    }

    public function testConstructorHydratesCorrectly(): void
    {
        $token = new Token($this->validData);

        $this->assertFalse($token->hasErrors());
        $this->assertSame('test_token_84', $token->getAccessToken());
        // Verifying the math: time() + expires_in
        $this->assertGreaterThanOrEqual(time() + 3599, $token->getExpiresAt());
    }

    public function testSerializationSupportsModernInternalInterface(): void
    {
        $token = new Token($this->validData);
        $serialized = serialize($token);
        
        /** @var Token $unserialized */
        $unserialized = unserialize($serialized);

        $this->assertInstanceOf(Token::class, $unserialized);
        $this->assertSame($token->getJti(), $unserialized->getJti());
    }
}
