<?php declare(strict_types=1);

/*
 * Copyright 2025 Stanford Electrical Engineering
 * https:/ee.stanford.edu <reric@ee.stanford.edu>
 *
 * Licensed under the Academic Free License version 3.0
 *
 */

namespace Suee\StanfordAuthorization\Authorization\Factory;

use Http\Discovery\Psr17Factory;
use Http\Discovery\Psr18ClientDiscovery;
use Psr\Http\Client\ClientInterface;

class PsrFactory
{
    private static ?Psr17Factory $psr17Factory = null;
    private static ?ClientInterface $client = null;
    public static function createClient(): ClientInterface
    {
        return static::$client ?? Psr18ClientDiscovery::find();
    }

    public static function createPsr17Factory(): Psr17Factory
    {
        return static::$psr17Factory ?? new Psr17Factory();
    }
}
